local nortal_lock = challenge_info.nortal_lock
local nortal_key = challenge_info.nortal_key

local key_spec = 1
local lock_spec = 2
if nortal_lock then --oops outside terminology is backwards from terminology here
  key_spec = painted_as(Nortal.new(), 1)
end
if nortal_key then --oops outside terminology is backwards from terminology here
  lock_spec = painted_as(Nortal.new(), 2)
end

function make_key_impl(transform, idx, spec) --spec is an array of 5 values, giving heights of key
  local grid = {}
  for i,v in pairs(spec) do
    for z = 1,v do
      local keypos = Vector.new(i - 1, z - 1);
      grid_store(grid, transform:transform(keypos), idx)
    end
  end
  make_fully_connected_object(grid)
end
function make_key(spec)
  destroy_rectangle(location.key_generator.generate)
  destroy_rectangle(location.key_generator.mirror_source)
  make_key_impl(CoordinateTransform.new(location.key_generator.mirror_source.lesser), key_spec, spec);
  make_key_impl(CoordinateTransform.new(location.key_generator.generate.lesser), key_spec, spec);
end
function make_goal(spec)
  destroy_rectangle(location.key_checker.mirror_source)
  make_key_impl(CoordinateTransform.new(location.key_checker.mirror_source.lesser), key_spec, spec);
  local cospec = {};
  for i,v in pairs(spec) do
    cospec[i] = 4 - spec[i]
  end
  make_key_impl(CoordinateTransform.new(location.key_checker.mirror_source.lesser + Vector.new(0, 3), F2), lock_spec, cospec);
end

local input_key_pos = 1;
local output_key_pos = 1;
local spec_list = {
  {3, 3, 2, 1, 2},
  {3, 2, 1, 2, 3},
  {3, 2, 3, 2, 3},
  {1, 3, 3, 3, 3},
  {3, 3, 3, 2, 2},
  {1, 2, 1, 3, 1},
  {3, 3, 2, 1, 2},
  {1, 1, 1, 2, 1},
  {2, 3, 2, 1, 2},
  {3, 2, 2, 3, 3},
  {3, 2, 1, 3, 2},
  {2, 3, 3, 3, 2},
  {3, 1, 2, 3, 2},
  {1, 2, 1, 2, 2},
  {3, 3, 3, 3, 3},
  {1, 1, 1, 1, 1},
  {3, 1, 1, 1, 2},
  {3, 3, 3, 2, 2},
  {1, 2, 1, 1, 3},
  {3, 3, 2, 2, 2},
  {3, 3, 2, 2, 3},
  {1, 2, 3, 2, 3},
  {2, 2, 2, 2, 2},
  {1, 2, 1, 2, 2},
  {1, 2, 2, 1, 2},
  {2, 1, 3, 1, 2},
  {3, 1, 3, 2, 1},
  {3, 1, 1, 1, 1},
  {1, 2, 3, 2, 1}
};
function get_spec(n)
  if n > #spec_list then
    return get_spec(n - #spec_list)
  else
    return spec_list[n]
  end
end

destroy_rectangle(location.blue_generator.mirror_source)
destroy_rectangle(location.blue_generator.generate)
if nortal_key then
  game:place(location.blue_generator.mirror_source.lesser, painted_as(Nortal.new(), 2))
else
  game:place(location.blue_generator.mirror_source.lesser, Basic.new(2))
end
make_generator_and_mirror(location.blue_generator.mirror_source, location.blue_generator.generate, location.blue_generator.mirror);
game:create_graphic(Mirror.new(location.key_generator.mirror_source, location.key_generator.mirror));
game:create_graphic(Background.new(location.key_generator.mirror))
game:create_graphic(Blackout.new(location.blackouts.left[1], LEFT));
game:create_graphic(Blackout.new(location.blackouts.left[2], LEFT));
game:create_graphic(Blackout.new(location.blackouts.right[1], RIGHT));
local key_quota = game:add_quota(100, "matching pairs")
make_simple_goal_and_mirror(location.key_checker.check, location.key_checker.mirror_source, location.key_checker.mirror, {
  on_accept = function(ct)
    output_key_pos = output_key_pos + 1;
    make_goal(get_spec(output_key_pos))
    if key_quota:decrement() then
      win()
    end
  end,
  okay_callback = function()
    key_quota:set_okay(true)
  end,
  fail_callback = function()
    key_quota:set_okay(false)
  end
})
make_triggered_delete(location.key_checker.dispose, Vector.new(location.key_checker.dispose.greater.x, location.key_checker.dispose.lesser.y))
make_key(get_spec(1));
make_goal(get_spec(1));

game:each_step(function()
  if rectangle_empty(location.key_generator.generate) then
    input_key_pos = input_key_pos + 1
    make_key(get_spec(input_key_pos))
  end
end)
